/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.base.VWString;

public final class VWJoinType {
    private static final int MIN_JOIN_TYPE = 1;
    public static final int JOIN_TYPE_AND = 1;
    public static final int JOIN_TYPE_OR = 2;
    public static final int JOIN_TYPE_NONE = 3;
    private static final int MAX_JOIN_TYPE = 3;
    private static String[] LocalizedStrings = new String[]{new VWString("VW.api.VWJoinTypeAnd", "And").toString(), new VWString("VW.api.VWJoinTypeOr", "Or").toString(), new VWString("VW.api.VWJoinTypeNone", "None").toString()};

    public static String _get_FILE_DATE() {
        return "$Date: 2010-02-18 23:00:24 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/1 $";
    }

    public static String getLocalizedString(int theJoinType) throws VWException {
        if (!VWJoinType.isValid(theJoinType)) {
            throw new VWException("vw.api.VWJoinTypeBadInteger", "Integer form of the join type is invalid: {0}", String.valueOf(theJoinType));
        }
        return LocalizedStrings[theJoinType - 1];
    }

    public static boolean isValid(int theJoinType) {
        return theJoinType >= 1 && theJoinType <= 3;
    }

    protected static String typeToString(int joinType) throws VWException {
        switch (joinType) {
            case 1: {
                return "and";
            }
            case 2: {
                return "or";
            }
            case 3: {
                return "none";
            }
        }
        throw new VWException("vw.api.VWJoinTypeBadInteger", "Integer form of the join type is invalid: {0}", String.valueOf(joinType));
    }

    protected static int stringToType(String joinType) throws VWException {
        if (joinType.equals("and")) {
            return 1;
        }
        if (joinType.equals("or")) {
            return 2;
        }
        if (joinType.equals("none")) {
            return 3;
        }
        throw new VWException("vw.api.VWJoinTypeBadString", "Integer form of the join type is invalid: {0}", joinType);
    }
}

